# 00-overview – Vue fonctionnelle globale

## Contexte général

Skyboard est un gestionnaire de projets universels, extrêmement modulable et flexible, basé sur un noyau V4 strict :

- snapshot JSON versionné comme source de vérité,
- moteur de règles unifié (RulesEngine, arbitre par strates),
- bus de commandes HTTP unique (`POST /api/commands`),
- packs MCC déclaratifs (tags système, datasets, règles, slots UI).

La V1 actuelle fournit :

- un socle fonctionnel minimal mais cohérent (workspaces, colonnes, items container/leaf),
- un moteur logique déjà solide et testé,
- une mécanique de packs d’extension permettant d’ajouter des fonctionnalités sans toucher au noyau.

L’objectif global est d’atteindre une version « finie » (par rapport à tes attentes) où :

- les futurs packs (Gestion, Relations, Interaction, Logique, Teams, Community) cohabitent sans contradictions,
- le système reste propre, découplé, standardisé, sans solutions ad hoc locales.

Ce dossier `design-evolution/` sert de bac à sable pour figer progressivement :

- la vision fonctionnelle globale,
- les fondations transverses,
- puis les phases métier une par une,
- avant de figer quoi que ce soit dans le code.

## Vision système (sans packs commerciaux)

On distingue volontairement :

- les **moteurs internes** (systèmes techniques : progression, relations, actions, logique, droits, publication),
- de leur **exposition** éventuelle sous forme de packs visibles/licenciés côté utilisateur.

Les phases de design sont donc orientées « systèmes internes » :

- `01-foundations` : identifiants globaux, adressage, sélection universelle, temps/événements, sémantique `container`/`leaf`, philosophie des tags.
- `02-gestion` : gestion des états avancés (en retard, bloqué, échoué), dates/échéances, progression numérique, éventuelles ressources matérielles, agrégation fonctionnelle.
- `03-relations` : moteur de relations typées entre items, hiérarchies fonctionnelles, prévention des cycles, intégration avec la structure container/leaf.
- `04-interactions` : moteur d’actions « Avant / Après » (conditions / effets), ciblage générique vs ciblage précis, politiques de fallback.
- `05-logic` : extension des types (états, échéances, relations…), définition de règles custom, articulation avec le moteur de règles existant.
- `06-teams` : modèle de permissions, scopes, hiérarchie des droits, interaction avec les commandes et les événements.
- `07-community` : hub public, publication de boards/containers, contributions, tri géographique et exposition contrôlée.
- `08-library` : bibliothèque de modèles réutilisables (items, sous-arbres, actions, configurations) et intégration avec Community pour les modèles publics.
- `09-activity` : journalisation et visualisation de l’activité (par board, par utilisateur, par item).

Chaque phase dispose :

- d’un document **fonctionnel** (ce fichier) décrivant l’objectif métier, les scénarios d’usage, les invariants,
- d’un document **technique** décrivant les structures de données, points d’intégration, règles et flux.

Avant toute implémentation significative, une phase de **synthèse globale**
(`ZZ-global-synthesis`) vérifiera la cohérence d’ensemble et fixera les décisions structurantes.

## Invariants transverses des packs métier

Certains choix structurants sont communs à tous les packs et DOIVENT rester vrais partout :

- **Progression & structure**  
  - La progression agrégée d’un ensemble d’items NE DOIT JAMAIS être déduite directement de la structure container/leaf (enfants d’un container).  
  - Toute agrégation de progression DOIT passer par des relations explicites et/ou des règles Logique.  
  - L’UI NE DOIT PAS afficher de progression “de groupe” si aucune relation ou règle ne la définit.

- **Relations vs structure**  
  - La structure (container/leaf + ordre) décrit “où les choses sont rangées”.  
  - Les relations décrivent “comment les choses dépendent les unes des autres” et servent de base aux agrégations fonctionnelles (progression, retards, blocages, etc.).  
  - Les assistants UID (“rendre cette liste fonctionnelle”, etc.) NE FONT QUE proposer puis créer des relations explicites (une fois pour toutes), jamais de mode caché qui recalcule en continu à partir de la structure.

- **Interactions vs Logique**  
  - Interactions porte des actions locales, centrées sur un **item porteur** : l’événement déclencheur concerne toujours cet item.  
  - Une action Interactions NE DOIT PAS nécessiter de parcourir l’ensemble du board ; son scope doit être limité (sélection explicite, container ciblé, voisins liés, etc.).  
  - Dès qu’un comportement est exprimé comme “dans ce board, la règle est que…”, il relève du pack Logique, pas d’Interactions.

- **Teams vs Logique (permissions)**  
  - Teams est la SEULE source de vérité des droits : qui peut voir/faire quoi.  
  - Logique PEUT lire des informations issues de Teams (rôles, capabilities, appartenance…) comme conditions, mais NE DOIT JAMAIS modifier directement les permissions.  
  - Toute mutation effective des droits passe par les mécanismes Teams (commandes et règles dédiées).

- **Activity & visibilité**  
  - Le moteur Activity maintient un journal interne complet.  
  - Chaque vue d’activité (par board, par utilisateur, par item) DOIT être filtrée par Teams : aucun événement concernant un contenu invisible ne doit “fuiter”.  
  - Il est ACCEPTÉ que deux utilisateurs voient des journaux différents pour un même board ; les “trous” ne sont pas signalés explicitement.

- **Community & Library (partage)**  
  - Publier un board/container/modèle dans Community n’accorde AUCUN droit nouveau sur le board source ; Teams reste souverain.  
  - Importer/forker crée toujours une **copie** : aucune modification dans un fork ne remonte automatiquement vers l’original (et inversement).  
  - Un modèle Library est un **snapshot** de départ, pas un lien vivant ; tout mécanisme éventuel de “modèles liés” sera une feature distincte, avec ses propres invariants.

## Scénario global cible (high level)

À terme, un utilisateur doit pouvoir :

- Construire des boards complexes avec des containers imbriqués, tout en gardant une structure interne propre et vérifiée (invariants du modèle).
- Suivre la progression d’items et d’ensembles d’items (containers) avec une granularité fine, visuelle et logique.
- Définir des relations de dépendance/hiérarchie entre items, automatiquement ou manuellement, et exploiter ces relations (retard, blocage, propagation d’état).
- Créer des actions qui réagissent à des conditions (« Avant ») et produisent des effets (« Après »), en ciblant des items précis ou des ensembles d’items via des politiques génériques.
- Étendre le système en ajoutant de nouveaux types d’états, d’échéances, de relations, et en écrivant des règles logiques personnalisées qui se branchent sur le moteur existant.
- Travailler à plusieurs sur un board, avec des droits finement contrôlés, qui encouragent l’initiative sans permettre de « casser » le board.
- Rendre publics certains boards/containers dans un hub communautaire, attirer des contributeurs, et exposer des besoins issus des actions/logique internes.

Ce bac à sable de design doit progressivement rendre ce scénario global cohérent, sans contradictions entre les différentes phases, avant que le code ne vienne figer les décisions.
