# 00-overview – État technique actuel

## Architecture existante (V4)

- Backend PHP structuré en couches :
  - `Domain/` : modèle métier (`BoardState`, `BoardPatch`, `BoardStateApplier`, `BoardInvariantChecker`, Rules, Identifiers, etc.).
  - `Application/` : commandes, handlers, services (`CommandBus`, `ProposedChange`, `BoardCatalog`, etc.).
  - `Infrastructure/` : persistance, HTTP, sécurité, packs MCC, logging, scheduler, etc.
  - `Interfaces/` : contrôleurs HTTP exposant une API JSON canonique.

- Modèle de board :
  - Snapshot JSON v4 versionné comme source de vérité (voir `docs/v4-master.md`).
  - Invariants (voir `docs/data-model-invariants.md`) :
    - parent unique,
    - ordre strict sans trou,
    - `sys.shape ∈ {container, leaf}`,
    - un `leaf` ne peut pas avoir d’enfants,
    - pas de cycles dans le graphe parents/enfants.
  - Mutations appliquées via `BoardPatch` + `BoardStateApplier`, opération inconnue ⇒ erreur.

- Règles et packs :
  - Moteur de règles (`Domain/Rules/*`) avec `RuleDefinition`, `RuleSet`, `RulesEngine`, etc.
  - Packs MCC déclaratifs (`packs/*`) décrivant :
    - tags système,
    - datasets,
    - slots UI,
    - règles,
    - quelques options de configuration.
  - Pack `org` existant :
    - tags d’état de base (`state/{todo,doing,done}`),
    - tags de type (`type/{note,image,list}` aujourd’hui ; à terme, les rôles structurels seront portés par `structure/*`),
    - dataset catégories/icônes,
    - règles d’exclusivité d’états,
    - réacteur structurel (`StructureTagReactor`) aligné actuellement sur `type/list`.

- Structure / tags :
  - Générateur d’identifiants globaux `Identifiers::new()` (UUID v4) utilisé pour les nodes / workspaces / colonnes.
  - Dans l’état actuel du code, le tag structurel `type/list` est relié à `sys.shape = "container"` via un réacteur système.
  - Le design cible décrit dans `01-foundations` remplace progressivement ce couplage par des tags noyau `structure/folder` et `structure/hierarchy`, seuls autorisés à muter `sys.shape` de manière contrôlée.

- Pipeline de commande :
  - Commandes (`Application/Commands/*`), dispatch via `CommandBus`.
  - Chaque handler retourne un `ProposedChange` (patch + événements métier).
  - Passage dans un Arbitre + `RulesEngine` + Reactors.
  - Application du patch, vérification des invariants, persistance, réponse HTTP JSON.

## Objectif du dossier `design-evolution/`

Ce dossier doit :

- fournir une base structurée pour les décisions **transverses** :
  - identifiants, adressage, sélection universelle,
  - gestion du temps/événements,
  - sémantique `container`/`leaf`,
  - philosophie des tags (data vs comportement),
- détailler phase par phase les systèmes internes :
  - progression,
  - relations,
  - interactions (actions),
  - logique (règles utilisateur, extensions de types),
  - droits (Teams),
  - ouverture (Community).

Ces décisions doivent rester compatibles avec :

- le modèle de snapshot v4,
- le pipeline `CommandBus → RulesEngine → BoardStateApplier`,
- la philosophie des packs MCC (déclaratifs, sans API HTTP dédiée).

Les autres sous-dossiers de `design-evolution` détaillent, pour chaque phase :

- une vue **fonctionnelle** (`functional.md`) : objectifs métier, scénarios, invariants,
- des **spécifications techniques** (`technical.md`) : structures, intégrations, flux, risques.
