# 05-logic – Spécifications techniques

## 1. Format et stockage des règles

- Stockage par board dans un bloc versionné `ext.logic.rules` (ou table dédiée) : pas dans les manifests MCC système.
- Une règle :

```json
{
  "id": "rule-id",
  "enabled": true,
  "priority": 100,
  "scope": "board",
  "triggers": ["state:enter:state/late", "time:tick-daily"],
  "conditions": { "op": "and", "conditions": [ { "type": "tag-missing", "target": "self", "tag": "state/done" } ] },
  "actions": [ { "type": "add-tag", "target": "self", "tag": "state/late" } ],
  "budget": { "actions": 50, "depth": 3 }
}
```

- `priority` : ordre d’évaluation (plus petit = évalué d’abord).
- `scope` : V1 = `board` (règle s’applique au board courant).
- `budget` : limites locales (nombre d’actions, profondeur de cascade).

## 2. Triggers disponibles V1

- Temps : `time:tick-daily`, `time:tick-hourly`.
- États : `state:enter:<state>`, `state:exit:<state>`.
- Deadlines : `deadline:passed`.
- Progression : `progress:threshold-crossed` (>= valeur donnée).
- Relations : `relation:created`, `relation:deleted`.
- Commandes : `command:<type>` (optionnel, si exposé).
- Les triggers porteur-centrés supplémentaires peuvent être exposés à Interactions (toujours centrés sur l’item porteur).

## 3. Conditions (vocabulaire V1)

- Predicates typés, combinables via arbres AND/OR :
  - `tag-has` / `tag-missing`
  - `state-is`
  - `progress-at-least`
  - `deadline-passed`
  - `relation-exists` (avec `kind`, direction, distance max)
  - `in-container` (appartenance à un container)
  - `actor-has-capability` (rôles/capabilities Teams)
  - `assigned-to-actor` (présence `assigned/<actor>`)
- `target` : `self` (item concerné par le trigger) ou `scope` (cibles résolues par un projector) ; distance via relations bornée configurablement.

## 4. Actions (effets V1)

- `add-tag` / `remove-tag` (états compris, respect des invariants Gestion).
- `set-progress` (respect des bornes).
- `set-deadline`.
- `create-relation` / `delete-relation` (respect acyclicité/contraintes Relations).
- `create-item` / `delete-item`.
- `veto` : refuser une mutation en cours avec code/ message explicite.
- Aucun effet sur Teams (permissions) ni sur des boards externes.
- Toutes les actions se traduisent en commandes standards via le CommandBus.

## 5. Priorités et overrides

- Hiérarchie : invariants noyau > règles packs non overridables > règles packs overridables > règles custom (triées par `priority`).
- Une règle custom ne peut supplanter qu’une règle pack marquée `overridable=true`; sinon elle coexiste sans effet d’override.
- En cas de conflit d’effets détectable (même trigger/scope/champ avec actions opposées) : l’évaluation échoue explicitement (pas de last-wins implicite) avec log Activity.
- Les règles désactivées sont ignorées mais restent persistées.

## 6. Budget et garde-fous

- Budget global par **déclenchement de trigger / cascade** :
  - nb max de règles évaluées pour un même trigger,
  - nb max d’actions produites dans cette cascade,
  - profondeur max de cascade (règle déclenche Interactions qui déclenche Logique, etc.).
- Dépassement budget ⇒ arrêt de l’évaluation, log Activity avec un code explicite (ex. `LOGIC_BUDGET_EXCEEDED`).
- Détection de cycles entre règles : tracer les runs (runId, source trigger) et stopper si on boucle sur la même combinaison trigger+cible.

## 7. Points d’intégration

- **Chargement** : `RulesCatalog` charge règles packs + règles custom (ext.logic.rules) au boot du board.
- **Évaluation** : `RulesEngine` reçoit les triggers issus des handlers/scheduler, projette le contexte (`boardId`, `nodeId`, tags, deadlines, relations, capabilities acteur).
- **Permissions** : chaque action générée est vérifiée via Teams (acteur = déclencheur du trigger). Pas de bypass “système”.
- **Interactions** :
  - les configurations JSON d’Interactions (`ext.interactions.actions`) sont compilées en règles Logic
    porteur‑centrées au chargement du board ; à l’exécution, le RulesEngine ne distingue pas si une règle
    provient d’un pack MCC, de `ext.logic.rules` ou d’Interactions,
  - Logic peut publier des triggers porteur‑centrés supplémentaires utilisables par Interactions
    (ex. `on-progress-threshold`, `on-late`), toujours dans ce même moteur unique.
- **Activity** : chaque run (règle évaluée) est journalisé avec `ruleId`, `runId`, `actorId`, `actions exécutées/échouées`, budget consommé.

## 8. Questions / risques

- Performance sur gros boards : projection du contexte doit rester incrémentale (éviter scans complets).
- UX : éditeur de règles lisible (phrases proches du métier) + outil de debug “pourquoi ma règle ne s’est pas déclenchée ?”.
- Sécurité : pas d’effet sur Teams, pas de cross-board ; surveiller la dérive des distances dans `relation-exists`.
