# 07-community – Spécifications techniques

> ⚠️ **Périmètre V1**  
> Le pack Community n’est **pas** dans le périmètre de la première version mise en production.  
> Ce document décrit une phase ultérieure (post‑V1) et sert de base de design ; aucune implémentation
> n’est requise tant que Fondations, Gestion, Relations, Interactions, Logic et le cœur de Teams
> ne sont pas stabilisés.

## Concepts techniques clés

- Publication explicite : board entier, sous-arbre, ou modèle Library.
- Expurgation systématique : suppression Teams (rôles, grants, denies), `assigned/*`, données internes/notes privées non publiables.
- Actions/règles publicables : incluses mais **inactives** dans l’importeur ; l’admin doit les activer explicitement. Scheduler/logique désactivés par défaut dans le board importé/forké.
- IDs : réécriture des `boardId/nodeId` à l’import/fork ; aucun lien vivant vers la source.

## Points d’intégration

- Endpoints : publication/retrait (POST/DELETE), import/fork (POST), liste/recherche (GET).
- Respect Teams : seules les personnes autorisées peuvent publier/retraiter ; aucun droit nouveau n’est accordé par la publication (lecture seule côté hub).
- Activity : publication/retrait/import/fork journalisés (`community.publish`, `community.fork`, etc.).

## Structures de données

- Entité publiée (exemple) :

  ```json
  {
    "id": "public-uuid",
    "sourceBoardPublicId": "uuid",
    "kind": "board|container|template",
    "snapshot": { ...expurgé... },
    "actions": [ ... inactives ... ],
    "rules": [ ... inactives ... ],
    "metadata": { "title": "...", "description": "...", "tags": ["..."], "owner": "userId" },
    "createdAt": 1736463600,
    "updatedAt": 1736463600
  }
  ```

- Le snapshot expurgé ne contient aucune donnée de permissions ni d’assignation.

## Flux types

- Publication :
  - auteur choisit périmètre (board/sous-arbre/template),
  - expurgation,
  - stockage avec `publicId`,
  - log Activity.
- Retrait : marque le contenu comme non listé, supprime les liens du hub.
- Import/fork :
  - récupération du snapshot expurgé,
  - régénération des `nodeId` et attribution d’un nouveau `boardId`,
  - actions/règles importées stockées **désactivées**,
  - scheduler/logique désactivés tant qu’ils ne sont pas activés manuellement,
  - log Activity avec source/target.

## Questions ouvertes / risques

- Modération/abus sur le hub.
- Poids et volumétrie des snapshots publiés.
- Gestion des dépendances vers des packs privés/licenciés lors de la publication.
