# 08-library – Vue fonctionnelle

> ⚠️ **Périmètre V1**  
> Le pack Library est pensé comme une **phase ultérieure** : il n’est pas dans le périmètre de la
> première version mise en production. Ce document sert de vision fonctionnelle à moyen terme, à
> valider lorsque le noyau (Fondations, Gestion, Relations, Interactions, Logic, Teams) sera stabilisé.

Ce document décrit le pack Library (ou Templates) : la capacité pour un utilisateur de
**sauvegarder des modèles réutilisables** (items, sous-arbres, actions, configurations) et
de les réinjecter facilement dans ses boards.

---

## 1. Contexte / Problème

Actuellement, l’utilisateur peut construire des structures très riches à base de tags, de
containers, d’actions, de relations, etc.  
Mais il manque une façon :

- d’enregistrer ces structures comme **modèles**,
- de les réutiliser rapidement dans d’autres boards ou d’autres endroits du même board,
- de choisir quels modèles resteront **privés** et lesquels pourront être partagés (via Community).

Sans Library, on est condamné à :

- recréer à la main des structures identiques (perte de temps, risque d’erreur),
- limiter la réutilisation à des duplications lourdes (duplication de board complet, etc.).

---

## 2. Objectifs fonctionnels

Library doit permettre à un utilisateur de :

1. **Enregistrer des modèles**
   - Modèle d’item :
     - tags, progression (bornée), champs, propriétés, relations, actions associées (importées inactives), règles associées (importées inactives).
   - Modèle de container / sous-arbre :
     - structure d’items et de containers imbriqués,
     - paramètres (tags, dates relatives, actions et relations “prêtes à l’emploi”).
   - Modèle d’action / configuration :
     - actions Interactions préconfigurées,
     - fragments de logique (patterns courants).

2. **Réutiliser facilement ces modèles**
   - Depuis une palette de “templates” :
     - insérer un item basé sur un modèle,
     - insérer un sous-arbre (container + contenu),
     - cloner une action préconfigurée (arrive inactive par défaut).
   - Choisir le comportement pour :
     - les dates (relatives, recalculées à partir de “aujourd’hui”),
     - certains tags (ex. tags d’affectation),
     - l’activation ou non des actions/règles importées (par défaut : inactives).

3. **Gérer la visibilité des modèles**
   - Modèles **privés** :
     - visibles et utilisables uniquement par l’utilisateur qui les a créés.
   - Modèles **de board** / d’équipe :
     - partagés avec l’équipe sur un board donné (en fonction des droits Teams).
   - Modèles **publics** :
     - publiés via Community, réutilisables par d’autres utilisateurs.
   - Nettoyage publication :
     - suppression/anonymisation des tags d’affectation `assigned/*` et données sensibles,
     - inclusion de la logique/actions internes uniquement sur opt-in explicite lors de la publication (et elles arrivent inactives par défaut chez l’importeur),
     - les notes/commentaires marqués comme internes ne sont pas exportés par défaut ; seuls ceux explicitement marqués comme publiables sont inclus.

4. **Organiser la bibliothèque**
   - Classer les modèles (catégories, tags, recherche).
   - Voir quels modèles sont les plus utilisés.

---

## 3. Scénarios d’usage

### 3.1. Sauvegarder un modèle de tâche complexe

- L’utilisateur configure une tâche avec :
  - tags d’état, catégorie, progression, échéances,
  - quelques relations et actions associées.
- Il choisit “Enregistrer comme modèle…” :
  - donne un nom (“Tâche de développement standard”),
  - le modèle apparaît dans Library.
- Dans un autre board, il peut ajouter une nouvelle tâche en choisissant ce modèle,
  puis adapter les détails au contexte.

### 3.2. Réutiliser un sous-arbre de projet

- L’utilisateur a construit un container “Projet type” :
  - avec des sous-tâches, phases, ressources, actions déjà prêtes.
- Il l’enregistre comme modèle de container.
- Dans un nouveau board, il insère “Projet type” :
  - il obtient la même structure, prête à être personnalisée.

### 3.3. Partager un modèle via Community

- L’utilisateur a un modèle de “Sprint agile” qu’il trouve utile.
- Il choisit de le publier :
  - soit en tant que template d’item,
  - soit en tant que template de board / container.
- Ce modèle apparaît dans le hub Community, d’autres peuvent l’importer dans leurs boards.

---

## 4. Contraintes & invariants métiers

### 4.1. Séparation modèle / instance

- Un modèle est un **schéma de départ**, pas un lien vivant :
  - modifier un modèle après coup n’altère pas les instances déjà créées,
  - sauf décision explicite dans une phase ultérieure (non prévue par défaut).
- Il n’existe pas, par défaut, de synchronisation automatique entre modèle et instances :
  - toute fonctionnalité de “modèle lié” ou de propagation de modifications devra être spécifiée comme
    feature distincte, avec des règles dédiées,
  - Library reste sinon strictement basée sur des copies indépendantes.

### 4.2. Respect des permissions

- Seuls certains rôles (via Teams) peuvent :
  - créer des modèles d’équipe,
  - publier des modèles publics.
- Les modèles ne doivent pas fuiter des informations confidentielles lorsqu’ils passent en “public”.

### 4.3. Cohérence avec les packs

- Library s’appuie sur :
  - Gestion (états, échéances, progression),
  - Relations,
  - Interactions,
  - Logique,
  - Teams, Community.
- Il doit respecter leurs invariants (structure, relations, permissions) lors de la création d’instances à partir de modèles.

---

## 5. Interactions avec les autres systèmes

- **Avec Community** :
  - Community est le canal de publication de modèles publics,
  - Library gère la composition et l’usage de modèles, Community la diffusion.
- **Avec Teams** :
  - Teams détermine qui peut créer / modifier / partager des modèles d’équipe.
- **Avec Interactions & Logique** :
  - des modèles peuvent inclure des actions / règles préconfigurées,
  - l’utilisateur peut choisir s’il veut les inclure ou non lors de l’insertion.
