# ZZ-global-synthesis – Synthèse globale (technique)

Ce document fige les choix techniques finaux après relecture croisée de tous les autres dossiers.

## Décisions techniques clés

- **Identifiants & adresses**  
  - `boardId` interne (id existant) reste la clé métier ; `publicBoardId` (UUID opaque) pour Community/Library.  
  - Adresse canonique d’un node : `{ boardId, nodeId }`. Isolation stricte intra-board V1 (aucune commande multi-board).  
  - Node racine : `root` constant, non supprimable ni déplaçable.

– **Structure & tags système**  
  - `sys.shape` seule vérité structurelle (`container`/`leaf`), aucun enfant pour un `leaf`.  
  - Deux tags noyau `structure/folder` et `structure/hierarchy` donnent une sémantique aux containers et peuvent promouvoir un `leaf` en `container` (promotion contrôlée, jamais de rétrogradation automatique).  
  - Aucun autre tag ne peut muter `sys.shape`. Registre global des tags système ; préfixes réservés bloqués côté back si non déclarés.

- **États & progression**  
  - Un item peut n’avoir **aucun** état principal, ou **exactement un** dans `{ todo, doing, done, failed }` (exclusifs). Flags `blocked/late` autorisés seulement avec `todo/doing`; transition vers `done/failed` supprime automatiquement ces flags. Combinaisons interdites rejetées (`STATE_COMBINATION_INVALID`).  
  - Progression : `progressMax ∈ [0, 10_000]`, `progressCurrent ∈ [0, progressMax]`; `max=0/null` = progression inconnue. Rescale ratio (round + clamp) lors d’un changement de `max`.  
  - Invariant minimal : si un item possède à la fois `state/done` et une progression, alors `progressCurrent = progressMax` ; toute commande qui viole cette contrainte est refusée (pas de correction silencieuse).  
  - Agrégation V1 = readiness fonctionnelle : `min` des dépendances (`depends=true`). Aucun calcul par structure.

- **Relations**  
  - Chaque type déclare `depends: boolean`. Toutes les relations `depends=true` (dont `rel/depends-on` et `rel/blocks`) appartiennent au même DAG acyclique ; création rejetée en cas de cycle.  
  - `rel/linked` (symétrique) hors DAG ; stockage unique, refus du miroir.  

– **Sélection & atomicité**  
  - Service UI de sélection : prévisualisation, critères persistés, pas les résultats.  
  - Interactions/Logic : sélection recalculée back au run ; 0 cible ou cible non éditable → 422/409, aucun effet (tout ou rien).  
  - Actions UI ponctuelles : best-effort (ignore cibles disparues ou non éditables) + avertissements.  
  - Commandes atomiques utilisent la version de snapshot ; conflit de version → rejet ; support `idempotencyKey` (acteur + key) pour éviter les doublons réseau.

- **Interactions / Logic**  
  - Moteur unique : toutes les règles (packs MCC, `ext.logic.rules`, Interactions compilées) sont évaluées par un seul RulesEngine. La configuration JSON d’Interactions est compilée en règles Logic porteur‑centrées au chargement du board.  
  - Trigger Interactions V1 : transition `non-done → done` du porteur. Pas d’actions planifiées créées depuis Interactions V1.  
  - Effets autorisés : create-item, update état/tags, set-progress, adjust-resource (non négatif), create/delete relation (`depends` acyclique). Effets interdits : mutation Teams, mutation Logic/packs, mutation cross-board.  
  - Cascade guard : contexte global avec `maxDepth`, `maxEffects`, set `(rule/action, item, triggerSignature)` pour éviter les répétitions dans la même cascade.  
  - Logic : règles customs après packs overridables ; conflit d’effets détectable (même trigger/scope/champ) → échec explicite, pas de last-wins implicite. Triggers supplémentaires exposables : progression (seuils), deadline, resource-below-threshold, relation added/removed.

- **Permissions & visibilité**  
  - Teams seule source de droits ; chaque effet vérifié côté back.  
  - Activity filtrée : événements invisibles si aucun droit de lecture ; redaction des références invisibles, pas de fuite de quantités.

- **Publication / import**  
  - Fork/import : remap `boardId/nodeId`, actions/règles importées inactives par défaut, scheduler désactivé tant qu’il n’est pas explicitement activé.  
  - Publication Community/Library : snapshot expurgé (Teams, assigned, données internes), actions/règles marquées publicables seulement, inactives à l’import. Community/Library sont conçus comme une phase **post‑V1** : aucun engagement d’implémentation tant que le noyau (Fondations, Gestion, Relations, Interactions, Logic, Teams) n’est pas stabilisé.

## Contrats techniques transverses

- Invariants noyau non overridables : acyclicité (`depends=true`), `leaf` sans enfants, états principaux exclusifs, ressources non négatives, bornes de progression.  
- Hiérarchie : Invariants noyau > règles packs non override > règles packs override > règles Logic custom > configurations Interactions.  
- Sélection : Interactions/Logic atomiques → recalcul back obligatoire ; commandes UI batch → best-effort consigné.  
- Permissions : aucune mutation effective sans validation Teams ; Interactions/Logic ne modifient jamais Teams.  
- Idempotence : réseau via `idempotencyKey`; métier via conditions explicites/flags dans les règles, pas via heuristique temporelle.  
- Aucune relation ou état invalide ne doit être persisté (création refusée) ; sanity jobs ne suppriment que les artefacts auto.

## Plan d’implémentation

- Fondations : root constant, registre de tags système, garde `sys.shape`, adresses `{boardId, nodeId}`, `publicBoardId`.  
- Gestion : matrice d’états/flags, progression bornée + rescale, readiness=min, politique `late` (manual/eligible/auto).  
- Relations : types avec `depends`, DAG acyclique, sanitation auto.  
- Interactions V1 : configuration Interactions compilée en Logic porteur‑centré, trigger done, effets autorisés, anti-boucles, sélection recalculée.  
- Logic V1 : DSL MCC (triggers/conditions/actions), hiérarchie overrides, détection simple de conflits, triggers supplémentaires (progress, deadline, resource, relation).  
- Teams : rôles/capabilities, denies > allows (sauf owner), safeguards (dernier owner), filtrage Activity/selection.  
- Community/Library (phase 2+) : publication expurgée, import/fork remap IDs, logique inactive par défaut, templates dates relatives.  
- Activity : taxonomie fixée, runId pour runs d’actions/règles, filtrage par Teams, rétention configurable.

## Points de vigilance & risques résiduels

- Conflits de règles Logic : détection statique limitée V1 (même trigger/scope/champ) → risque de collisions non détectées si conditions complexes.  
- Sélection duale (best-effort UI vs échec global Interactions) : bien afficher les avertissements côté UI pour éviter l’incompréhension.  
- Cap progression 10 000 : suffisant pour V1, mais surveiller les besoins “metrics” avant d’augmenter la borne.  
- Sanity cycles : ne pas supprimer de relations manuelles automatiquement ; prévoir une UI de diagnostic pour aider les users.  
- Publication : veiller à ne pas exposer d’artefacts de permissions ou d’actions non publicables ; checklist d’expurgation à automatiser.
