let appRef = null;
let menuEl = null;
let onClose = null;
let onAction = null;

export function initContextMenu({ app, onRequestClose, onActionSelect }) {
  appRef = app ?? null;
  onClose = typeof onRequestClose === 'function' ? onRequestClose : null;
  onAction = typeof onActionSelect === 'function' ? onActionSelect : null;
  if (!menuEl) {
    menuEl = document.createElement('div');
    menuEl.className = 'board-context-menu';
    menuEl.setAttribute('aria-role', 'menu');
    menuEl.style.display = 'none';
    document.body.appendChild(menuEl);
    menuEl.addEventListener('click', handleMenuClick);
  }
  document.addEventListener('click', handleGlobalClick, true);
}

export function openContextMenu({ x, y, nodeId }) {
  if (!menuEl) return;
  const targetNode = typeof nodeId === 'string' ? nodeId : '';
  menuEl.innerHTML = `
    <ul class="board-context-menu__group">
      <li class="board-context-menu__item" data-action="context-move-node" data-node="${escapeAttr(targetNode)}">Déplacer…</li>
    </ul>
  `;
  if (!menuEl.parentElement) {
    document.body.appendChild(menuEl);
  }
  menuEl.style.display = 'block';
  menuEl.style.left = `${Math.max(8, x)}px`;
  menuEl.style.top = `${Math.max(8, y)}px`;
}

export function closeContextMenu() {
  if (!menuEl) return;
  menuEl.style.display = 'none';
  menuEl.innerHTML = '';
  if (onClose) {
    try { onClose(); } catch (_) {}
  }
}

export function isContextMenuOpen() {
  return !!menuEl && menuEl.style.display !== 'none';
}

function handleGlobalClick(event) {
  if (!isContextMenuOpen()) {
    return;
  }
  const isMenu = event.target instanceof Element
    ? event.target.closest('.board-context-menu')
    : null;
  if (!isMenu) {
    closeContextMenu();
  }
}

function handleMenuClick(event) {
  const target = event.target instanceof Element ? event.target.closest('[data-action]') : null;
  if (!target) return;
  const action = target.dataset.action;
  const nodeId = target.dataset.node || '';
  closeContextMenu();
  if (onAction) {
    onAction({ action, nodeId });
  }
}

function escapeAttr(value) {
  return (value || '').replace(/"/g, '&quot;');
}
