export function makePatch(boardId, operations = []) {
  return { boardId, operations };
}

export const Ops = {
  addTag: ({ nodeId, key, value, sys=false }) => ({ op: 'tag.add', nodeId, tag: { k: key, v: value, sys } }),
  removeTag: ({ nodeId, key }) => ({ op: 'tag.remove', nodeId, key }),
  nodeCreate: ({ parentId, index, nodeId, title, description=null, content=null, tags=[] }) => ({ op: 'node.create', parentId, index, nodeId, title, description, content, tags }),
  nodeMove: ({ nodeId, toParentId, toIndex }) => ({ op: 'node.move', nodeId, toParentId, toIndex }),
  nodeDelete: ({ nodeId }) => ({ op: 'node.delete', nodeId }),
};

export const TagKind = {
  system: 'system',
  user: 'user',
};

