import { buildAttachmentFromFile } from './attachments.js';

export function mapFileToAttachment(file, options = {}) {
  const role = typeof options.role === 'string' && options.role ? options.role : undefined;
  const kind = typeof options.kind === 'string' && options.kind ? options.kind : undefined;
  const origin = typeof options.origin === 'string' && options.origin ? options.origin : undefined;
  const meta = options.meta && typeof options.meta === 'object' ? options.meta : undefined;

  return buildAttachmentFromFile(file, {
    ...(kind ? { kind } : {}),
    ...(origin ? { origin } : {}),
    ...(role ? { role } : {}),
    ...(meta ? { meta } : {}),
  });
}
