import { requestJson } from './http.js';

export async function fetchBoardState(boardId) {
  const payload = await requestJson(`/api/boards/${encodeURIComponent(boardId)}/state`, { method: 'GET' });
  return {
    state: payload.state,
    meta: payload.meta ?? null,
  };
}

export async function fetchBoards() {
  const payload = await requestJson('/api/boards', { method: 'GET' });
  return payload.boards;
}

export async function createBoard(title, csrf) {
  const payload = await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.Create', payload: { title: title || '' } },
  });
  return payload.board;
}

export async function exportBoard(boardId) {
  const payload = await requestJson(`/api/boards/${encodeURIComponent(boardId)}/export`, { method: 'GET' });
  return payload.board;
}

export async function importBoard(payload, csrf) {
  const body = payload && typeof payload === 'object' ? payload : {};
  return await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.Import', payload: body },
  });
}

export async function renameBoard(boardId, title, csrf) {
  await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.Rename', payload: { boardId, title } },
  });
  return true;
}

export async function deleteBoard(boardId, csrf) {
  await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.Delete', payload: { boardId } },
  });
  return true;
}

export async function confirmAutosave(boardId, revision, csrf) {
  return await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.Autosave', payload: { boardId, revision } },
  });
}

export async function setBoardThumbnail(boardId, publicId, csrf) {
  const payload = { boardId };
  if (typeof publicId === 'string') {
    payload.publicId = publicId; // empty string clears
  }
  await requestJson('/api/commands', {
    method: 'POST',
    body: { type: 'Board.SetThumbnail', payload },
  });
  return true;
}
