// Lightweight debug utilities usable across apps/services

export function applyDebugFromUrl() {
  try {
    const url = new URL(window.location.href);
    const qp = url.searchParams.get('debug');
    if (qp === '1' || qp === 'true') {
      localStorage.setItem('sb.debug', '1');
      window.__SB_DEBUG__ = true;
    } else if (qp === '0' || qp === 'false') {
      localStorage.removeItem('sb.debug');
      window.__SB_DEBUG__ = false;
    }
  } catch (_) {
    // ignore
  }
}

export function isDebug() {
  if (typeof window !== 'undefined' && typeof window.__SB_DEBUG__ === 'boolean') {
    return window.__SB_DEBUG__;
  }
  try {
    const url = new URL(window.location.href);
    const qp = url.searchParams.get('debug');
    if (qp === '1' || qp === 'true') return true;
    if (qp === '0' || qp === 'false') return false;
  } catch (_) {
    // ignore
  }
  try {
    return localStorage.getItem('sb.debug') === '1' || localStorage.getItem('sb.debug') === 'true';
  } catch (_) {
    return false;
  }
}

export function debugLog(...args) {
  if (isDebug()) {
    // eslint-disable-next-line no-console
    console.debug('[SB:DEBUG]', ...args);
  }
}

export function toErrorMessage(error, fallback = 'Action impossible') {
  if (!error) return fallback;
  const status = error.status ?? error.code ?? null;
  const payloadMsg = error.payload?.message ?? error.payload?.error ?? null;
  const msg = error.message ?? payloadMsg ?? fallback;
  return status ? `${msg} (code ${status})` : msg;
}

