export class SBMenu extends HTMLElement {
  constructor() {
    super();
    this._toggle = this._toggle.bind(this);
    this._close = this._close.bind(this);
  }

  connectedCallback() {
    this.trigger = this.querySelector('[slot="trigger"]');
    this.panel = this.querySelector('[slot="menu"]');
    if (this.trigger && this.panel) {
      this.panel.hidden = true;
      this.trigger.addEventListener('click', this._toggle);
      document.addEventListener('click', this._close, true);
      this.trigger.setAttribute('aria-expanded', 'false');
    }
  }

  disconnectedCallback() {
    if (this.trigger) {
      this.trigger.removeEventListener('click', this._toggle);
    }
    document.removeEventListener('click', this._close, true);
  }

  _toggle(event) {
    event.stopPropagation();
    this.panel.hidden = !this.panel.hidden;
    if (this.trigger) {
      this.trigger.setAttribute('aria-expanded', this.panel.hidden ? 'false' : 'true');
    }
  }

  _close(event) {
    if (!this.contains(event.target)) {
      if (this.panel) {
        this.panel.hidden = true;
        if (this.trigger) {
          this.trigger.setAttribute('aria-expanded', 'false');
        }
      }
    }
  }
}

customElements.define('sb-menu', SBMenu);
