export class SBPopover extends HTMLElement {
  constructor() {
    super();
    this._toggle = this._toggle.bind(this);
    this._close = this._close.bind(this);
  }

  connectedCallback() {
    this.trigger = this.querySelector('[slot="trigger"]');
    this.content = this.querySelector('[slot="content"]');
    if (!this.trigger || !this.content) {
      return;
    }
    this.content.hidden = true;
    this.content.style.position = 'absolute';
    this.content.style.zIndex = '50';
    this.style.position = 'relative';
    this.trigger.addEventListener('click', this._toggle);
    document.addEventListener('click', this._close, true);
  }

  disconnectedCallback() {
    if (this.trigger) {
      this.trigger.removeEventListener('click', this._toggle);
    }
    document.removeEventListener('click', this._close, true);
  }

  _toggle(event) {
    event.stopPropagation();
    this.content.hidden = !this.content.hidden;
  }

  _close(event) {
    if (!this.contains(event.target)) {
      if (this.content) {
        this.content.hidden = true;
      }
    }
  }
}

customElements.define('sb-popover', SBPopover);
