const containerId = 'sb-toast-container';

function ensureContainer() {
  let node = document.getElementById(containerId);
  if (!node) {
    node = document.createElement('div');
    node.id = containerId;
    node.style.position = 'fixed';
    node.style.bottom = '20px';
    node.style.right = '20px';
    node.style.display = 'flex';
    node.style.flexDirection = 'column';
    node.style.gap = '10px';
    node.style.zIndex = '60';
    document.body.appendChild(node);
  }
  return node;
}

export function showToast(message, options = {}) {
  const container = ensureContainer();
  const toast = document.createElement('div');
  toast.textContent = message;
  toast.style.padding = '12px 16px';
  toast.style.borderRadius = '10px';
  toast.style.background = options.kind === 'error' ? '#fee2e2' : 'rgba(15, 23, 42, 0.9)';
  toast.style.color = options.kind === 'error' ? '#991b1b' : '#f8fafc';
  toast.style.boxShadow = '0 10px 30px rgba(15, 23, 42, 0.25)';
  toast.style.fontWeight = '500';
  container.appendChild(toast);
  const timeout = options.timeout ?? 3200;
  setTimeout(() => toast.classList.add('sb-toast-hide'), timeout - 200);
  setTimeout(() => toast.remove(), timeout);
}
