const HTML_ESCAPES = new Map([
  ['&', '&amp;'],
  ['<', '&lt;'],
  ['>', '&gt;'],
  ['"', '&quot;'],
  ['\'', '&#39;'],
  ['`', '&#96;'],
]);

export function escapeHtml(value) {
  return String(value ?? '').replace(/[&<>"'`]/g, (char) => HTML_ESCAPES.get(char) ?? char);
}

export function escapeAttr(value) {
  return escapeHtml(value);
}

export function capitalize(value) {
  const str = String(value ?? '').toLowerCase();
  if (!str) return '';
  return str.charAt(0).toUpperCase() + str.slice(1);
}

export function coerceDate(value) {
  if (value === null || value === undefined) return null;
  if (value instanceof Date) {
    return Number.isNaN(value.getTime()) ? null : value;
  }
  if (typeof value === 'number') {
    const ms = value < 1e12 ? value * 1000 : value;
    const date = new Date(ms);
    return Number.isNaN(date.getTime()) ? null : date;
  }
  const date = new Date(String(value));
  return Number.isNaN(date.getTime()) ? null : date;
}

export function formatDate(value) {
  const date = coerceDate(value);
  if (!date) return '';
  return date.toLocaleDateString('fr-FR', { month: 'short', day: 'numeric' });
}

export function formatDateTime(value) {
  const date = coerceDate(value);
  if (!date) return '';
  return date.toLocaleString('fr-FR', {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
    hour: '2-digit',
    minute: '2-digit',
  });
}

export function formatTime(value) {
  const date = coerceDate(value);
  if (!date) return '';
  return date.toLocaleTimeString('fr-FR', { hour: '2-digit', minute: '2-digit' });
}

export function formatTimeFromMs(value) {
  const date = coerceDate(value);
  if (!date) return '';
  return date.toLocaleTimeString('fr-FR', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
}
