<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class CreateNodeCommand implements Command
{
    /**
     * @param array<string,mixed> $payload
     */
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly array $payload
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    /** @return array<string,mixed> */
    public function payload(): array { return $this->payload; }
}


