<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class DeleteNodeCommand implements Command
{
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $nodeId
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    public function nodeId(): string { return $this->nodeId; }
}


