<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class MoveNodeCommand implements Command
{
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $nodeId,
        private readonly string $toParentId,
        private readonly int $toIndex
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    public function nodeId(): string { return $this->nodeId; }
    public function toParentId(): string { return $this->toParentId; }
    public function toIndex(): int { return $this->toIndex; }
}


