<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

use Skyboard\Domain\Boards\BoardPatch;

final class ProposedChange
{
    /**
     * @param list<array<string,mixed>> $events
     * @param list<array<string,mixed>> $postCommitEvents
     */
    public function __construct(
        private readonly BoardPatch $patch,
        private readonly array $events = [],
        private readonly array $postCommitEvents = []
    ) {
    }

    public function patch(): BoardPatch
    {
        return $this->patch;
    }

    /** @return list<array<string,mixed>> */
    public function events(): array
    {
        return $this->events;
    }

    /** @return list<array<string,mixed>> */
    public function postCommitEvents(): array
    {
        return $this->postCommitEvents;
    }
}

