<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class RemoveTagV3Command implements Command
{
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $nodeId,
        private readonly string $key,
        private readonly ?string $value = null
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    public function nodeId(): string { return $this->nodeId; }
    public function key(): string { return $this->key; }
    public function value(): ?string { return $this->value; }
}


