<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class UpdateNodeCommand implements Command
{
    /**
     * @param array<string,mixed> $changes
     */
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $nodeId,
        private readonly array $changes
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    public function nodeId(): string { return $this->nodeId; }
    /** @return array<string,mixed> */
    public function changes(): array { return $this->changes; }
}


