<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class UpdateTagFilterCommand implements Command
{
    /**
     * @param list<string> $selected
     */
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly array $selected
    ) {
    }

    public function boardId(): ?string
    {
        return $this->boardId;
    }

    public function actorId(): string
    {
        return $this->actorId;
    }

    /**
     * @return list<string>
     */
    public function selected(): array
    {
        return $this->selected;
    }
}
