<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\CreateColumnCommand;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardPatch;
use Skyboard\Domain\Shared\Identifiers;

final class CreateColumnHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof CreateColumnCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $columnId = Identifiers::new();
        $operations = [
            [
                'op' => 'node.create',
                'parentId' => $command->workspaceId(),
                'nodeId' => $columnId,
                'title' => $command->title(),
                'sys' => ['shape' => 'container'],
            ],
        ];
        $events = [[
            'name' => 'ColumnWillBeCreated',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => ['columnId' => $columnId],
        ]];
        $patch = new BoardPatch($command->boardId(), $operations);
        return new ProposedChange($patch, $events);
    }
}

