<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\MoveNodeCommand;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardPatch;

final class MoveNodeHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof MoveNodeCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $operation = [
            'op' => 'node.move',
            'nodeId' => $command->nodeId(),
            'toParentId' => $command->toParentId(),
            'toIndex' => $command->toIndex(),
        ];
        $events = [[
            'name' => 'NodeWillBeMoved',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}


