<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Application\Commands\RemoveTagV3Command;
use Skyboard\Domain\Boards\BoardPatch;

final class RemoveTagHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        // V3 RemoveTagV3Command
        if ($command instanceof RemoveTagV3Command) {
            $operation = [
                'op' => 'tag.remove',
                'scope' => 'item',
                'targetId' => $command->nodeId(),
                'nodeId' => $command->nodeId(),
                'key' => $command->key(),
            ];
            $events = [[
                'name' => 'TagWillBeRemoved',
                'boardId' => $command->boardId(),
                'actorId' => $command->actorId(),
                'context' => $operation,
            ]];
            $patch = new BoardPatch($command->boardId(), [$operation]);
            return new ProposedChange($patch, $events);
        }

        throw new \InvalidArgumentException('Unsupported command');
    }
}
