<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\UpdateNodeCommand;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardPatch;

final class UpdateNodeHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof UpdateNodeCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $changes = $command->changes();
        $operation = [
            'op' => 'node.update',
            'nodeId' => $command->nodeId(),
        ] + $changes;
        $events = [[
            'name' => 'NodeWillBeUpdated',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}


