<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\AuthService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountLogoutHandler implements NonBoardHandler
{
    public function __construct(private readonly AuthService $auth)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $session = $request->getAttribute('session');
        $cookie = 'sb_session=deleted; Path=/; Expires=Thu, 01 Jan 1970 00:00:00 GMT; SameSite=Lax; HttpOnly; Secure';
        if ($session) {
            $this->auth->logout($session['token']);
        }
        return Response::ok([], 200, ['Set-Cookie' => $cookie]);
    }
}

