<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\AccountService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountRedeemLicenseHandler implements NonBoardHandler
{
    public function __construct(private readonly AccountService $account)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $code = (string) ($payload['code'] ?? '');
        if (trim($code) === '') {
            return Response::error('CODE_REQUIRED', 'Code requis.', [], 422);
        }
        $result = $this->account->applyLicense($userId, $code);
        if (!$result['ok']) {
            return Response::error(strtoupper((string) ($result['error'] ?? 'unknown')), 'Activation de licence échouée.', [], 422);
        }
        return Response::ok(['role' => $result['role'] ?? 'standard']);
    }
}

