<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\EmailVerificationService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountRequestVerificationHandler implements NonBoardHandler
{
    public function __construct(private readonly EmailVerificationService $verification)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $result = $this->verification->request($userId);
        $response = [
            'expiresAt' => $result['expiresAt'],
            'sent' => $result['sent'],
        ];
        $appEnv = \Skyboard\config()['app_env'] ?? 'dev';
        if ($appEnv === 'dev') {
            $response['token'] = $result['token'];
        }
        return Response::ok($response);
    }
}

