<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\AccountService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountUpdateProfileHandler implements NonBoardHandler
{
    public function __construct(private readonly AccountService $account)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $pseudo = trim((string) ($payload['pseudo'] ?? ''));
        if ($pseudo === '') {
            return Response::error('PSEUDO_REQUIRED', 'Pseudo requis.', [], 422);
        }
        try {
            $this->account->updatePseudo($userId, $pseudo);
        } catch (\InvalidArgumentException $e) {
            return Response::error('INVALID_PARAMETERS', 'Paramètres invalides.', [], 422);
        }
        return Response::ok();
    }
}

