<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\BoardCatalog;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class BoardRenameHandler implements NonBoardHandler
{
    public function __construct(private readonly BoardCatalog $boards)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $boardId = (int) ($payload['boardId'] ?? 0);
        $title = trim((string) ($payload['title'] ?? ''));
        if ($boardId <= 0 || $title === '') {
            return Response::error('INVALID_PAYLOAD', 'Données invalides.', [], 422);
        }
        $this->boards->rename($boardId, $userId, $title);
        return Response::ok();
    }
}

