<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileComposeHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $result = $this->files->compose($userId, [
            'name' => (string) ($payload['name'] ?? ''),
            'content' => (string) ($payload['content'] ?? ''),
            'kind' => (string) ($payload['kind'] ?? ''),
            'format' => (string) ($payload['format'] ?? ''),
            'mimeType' => (string) ($payload['mimeType'] ?? ''),
        ]);
        return Response::ok(['file' => $result['file'], 'content' => $result['content']], 201);
    }
}

