<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileDeleteFolderCascadeHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $folderId = (string) ($payload['folderId'] ?? '');
        if ($folderId === '') {
            return Response::error('INVALID_PAYLOAD', 'Identifiant de dossier invalide.', [], 422);
        }
        $result = $this->files->deleteFolderCascade($userId, $folderId);
        return Response::ok(['deleted' => $result]);
    }
}

