<?php

declare(strict_types=1);

namespace Skyboard\Application\Services\Admin;

use PDO;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;
use Skyboard\Infrastructure\Persistence\SchemaManager;

final class SecurityAdminService
{
    public function __construct(
        private readonly DatabaseConnection $connection,
        private readonly SchemaManager $schema
    ) {
    }

    /**
     * @return list<array<string,mixed>>
     */
    public function ipRecords(): array
    {
        $stmt = $this->connection->pdo()->query('SELECT ip, fails, banned_until FROM ip_rec ORDER BY banned_until DESC, fails DESC');
        $rows = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
        return array_map(static function (array $row): array {
            $row['fails'] = (int) ($row['fails'] ?? 0);
            $row['banned_until'] = (int) ($row['banned_until'] ?? 0);
            return $row;
        }, $rows ?: []);
    }

    public function clearIp(string $ip): void
    {
        $stmt = $this->connection->pdo()->prepare('DELETE FROM ip_rec WHERE ip = :ip');
        $stmt->execute(['ip' => $ip]);
    }

    public function clearAllIps(): void
    {
        $this->connection->pdo()->exec('DELETE FROM ip_rec');
    }

    public function resetSchema(): void
    {
        $this->schema->migrate();
    }
}

