<?php

declare(strict_types=1);

namespace Skyboard\Application\Services;

use Skyboard\Domain\Boards\BoardPatch;
use Skyboard\Domain\Boards\BoardSnapshot;
use Skyboard\Domain\Boards\BoardState;
use Skyboard\Domain\Boards\BoardWriteResult;

interface BoardRepository
{
    public function getById(string $boardId, int $userId): ?BoardState;

    public function getSnapshot(string $boardId, int $userId): ?BoardSnapshot;

    public function applyPatch(BoardState $board, BoardPatch $patch, int $userId, ?int $expectedRevision = null): BoardWriteResult;

    public function overwrite(string $boardId, int $userId, BoardState $state, ?int $expectedRevision = null): BoardWriteResult;
}
