<?php

declare(strict_types=1);

namespace Skyboard\Application\Services;

use Skyboard\Domain\UserFiles\UserFile;

interface UserFileRepository
{
    /**
     * @return list<UserFile>
     */
    public function listForUser(int $userId): array;

    public function insert(UserFile $file): UserFile;

    public function findByPublicId(int $userId, string $publicId): ?UserFile;

    public function update(UserFile $file): void;

    public function delete(UserFile $file): void;
}
