<?php

declare(strict_types=1);

namespace Skyboard\Domain\Boards;

use RuntimeException;

final class BoardInvariantViolation extends RuntimeException
{
    public function __construct(private readonly string $reason, string $message)
    {
        parent::__construct($message);
    }

    public function reason(): string
    {
        return $this->reason;
    }
}

