<?php

declare(strict_types=1);

namespace Skyboard\Domain\Boards;

use JsonSerializable;

final class BoardPatch implements JsonSerializable
{
    /** @param list<array<string,mixed>> $operations */
    public function __construct(
        private readonly string $boardId,
        private readonly array $operations
    ) {
    }

    public function boardId(): string
    {
        return $this->boardId;
    }

    /** @return list<array<string,mixed>> */
    public function operations(): array
    {
        return $this->operations;
    }

    public function withOperations(array $operations): self
    {
        return new self($this->boardId, $operations);
    }

    public function jsonSerialize(): array
    {
        return [
            'boardId' => $this->boardId,
            'operations' => $this->operations,
        ];
    }
}

