<?php

declare(strict_types=1);

namespace Skyboard\Domain\Boards;

final class BoardWriteResult
{
    /**
     * @param list<array{revision:int,updatedAt:int}> $history
     */
    public function __construct(
        private readonly BoardState $board,
        private readonly int $revision,
        private readonly int $updatedAt,
        private readonly array $history = []
    ) {
    }

    public function board(): BoardState
    {
        return $this->board;
    }

    public function revision(): int
    {
        return $this->revision;
    }

    public function updatedAt(): int
    {
        return $this->updatedAt;
    }

    /**
     * @return list<array{revision:int,updatedAt:int}>
     */
    public function history(): array
    {
        return $this->history;
    }
}
