<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleActionOutcome
{
    /**
     * @param list<array<string,mixed>> $operations
     * @param array{reasonId:?string,message:?string}|null $rejection
     */
    public function __construct(
        private readonly array $operations,
        private readonly int $mutations,
        private readonly ?array $rejection = null
    ) {
    }

    /**
     * @return list<array<string,mixed>>
     */
    public function operations(): array
    {
        return $this->operations;
    }

    public function mutations(): int
    {
        return $this->mutations;
    }

    /**
     * @return array{reasonId:?string,message:?string}|null
     */
    public function rejection(): ?array
    {
        return $this->rejection;
    }
}
