<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleDefinition
{
    /**
     * @param list<string> $triggers
     * @param list<array<string,mixed>> $conditions
     * @param list<array<string,mixed>> $actions
     */
    public function __construct(
        private readonly string $id,
        private readonly string $scope,
        private readonly int $priority,
        private readonly array $triggers,
        private readonly array $conditions,
        private readonly array $actions,
        private readonly ?array $onVeto = null,
        private readonly ?string $source = null,
        private readonly ?string $description = null
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }

    public function scope(): string
    {
        return $this->scope;
    }

    public function priority(): int
    {
        return $this->priority;
    }

    /** @return list<string> */
    public function triggers(): array
    {
        return $this->triggers;
    }

    /** @return list<array<string,mixed>> */
    public function conditions(): array
    {
        return $this->conditions;
    }

    /** @return list<array<string,mixed>> */
    public function actions(): array
    {
        return $this->actions;
    }

    /** @return array<string,mixed>|null */
    public function onVeto(): ?array
    {
        return $this->onVeto;
    }

    public function source(): ?string
    {
        return $this->source;
    }

    public function description(): ?string
    {
        return $this->description;
    }
}
