<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleEvaluationTrace implements \JsonSerializable
{
    /** @var list<array<string,mixed>> */
    private array $entries = [];

    public function add(array $entry): void
    {
        $this->entries[] = $entry;
    }

    public function jsonSerialize(): array
    {
        return [
            'rulesVersion' => \Skyboard\config()['rules_version'] ?? '1',
            'evaluated' => $this->entries,
        ];
    }
}

