<?php

declare(strict_types=1);

namespace Skyboard\Domain\UserFiles;

final class UserFileFolder
{
    public function __construct(
        private ?int $id,
        private int $userId,
        private string $publicId,
        private string $name,
        private ?int $parentId,
        private int $createdAt,
        private int $updatedAt,
    ) {}

    public static function createNew(int $userId, string $publicId, string $name, ?int $parentId, int $timestamp): self
    {
        return new self(null, $userId, $publicId, $name, $parentId, $timestamp, $timestamp);
    }

    public function withId(int $id): self
    {
        $clone = clone $this;
        $clone->id = $id;
        return $clone;
    }

    public function withName(string $name, int $timestamp): self
    {
        $clone = clone $this;
        $clone->name = $name;
        $clone->updatedAt = $timestamp;
        return $clone;
    }

    public function id(): ?int { return $this->id; }
    public function userId(): int { return $this->userId; }
    public function publicId(): string { return $this->publicId; }
    public function name(): string { return $this->name; }
    public function parentId(): ?int { return $this->parentId; }
    public function createdAt(): int { return $this->createdAt; }
    public function updatedAt(): int { return $this->updatedAt; }

    /**
     * @return array<string,mixed>
     */
    public function toRecord(): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->userId,
            'public_id' => $this->publicId,
            'name' => $this->name,
            'parent_id' => $this->parentId,
            'created_at' => $this->createdAt,
            'updated_at' => $this->updatedAt,
        ];
    }
}

