<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Packs;

final class SystemTagRegistry
{
    /** @var array<string, TagDefinition> */
    private array $tags = [];

    public function register(string $packId, array $tagDefinitions): void
    {
        foreach ($tagDefinitions as $tagDef) {
            $key = $tagDef['key'] ?? '';
            if ($key === '') {
                continue;
            }

            $internalKey = $packId . ':' . $key;
            $this->tags[$internalKey] = new TagDefinition(
                $internalKey,
                $key,
                $tagDef['category'] ?? 'user',
                $tagDef['ui'] ?? [],
                $tagDef['fallback'] ?? ['asSimple' => true]
            );
        }
    }

    public function resolve(string $shortKey): ?TagDefinition
    {
        // Recherche directe par clé courte
        foreach ($this->tags as $tag) {
            if ($tag->shortKey === $shortKey) {
                return $tag;
            }
        }
        return null;
    }

    public function getAll(): array
    {
        return $this->tags;
    }

    public function getByCategory(string $category): array
    {
        return array_filter($this->tags, fn(TagDefinition $tag) => $tag->category === $category);
    }
}

final class TagDefinition
{
    public function __construct(
        public readonly string $internalKey,
        public readonly string $shortKey,
        public readonly string $category,
        public readonly array $ui,
        public readonly array $fallback
    ) {
    }
}
