<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Persistence;

use PDO;

final class DatabaseConnection
{
    private PDO $pdo;
    private string $driver;

    public function __construct(string $dsn, ?string $username = null, ?string $password = null)
    {
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ];

        if (!str_starts_with($dsn, 'mysql:')) {
            throw new \RuntimeException('DB_CONNECTION_UNSUPPORTED_DSN: seul mysql: est accepté.');
        }

        $options[PDO::ATTR_EMULATE_PREPARES] = false;
        if (defined('PDO::MYSQL_ATTR_INIT_COMMAND')) {
            $options[\PDO::MYSQL_ATTR_INIT_COMMAND] = 'SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci';
        }

        $this->pdo = new PDO($dsn, $username ?? '', $password ?? '', $options);
        $this->pdo->exec("SET time_zone = '+00:00'");
        $this->pdo->exec("SET sql_mode='STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION'");
        $this->driver = 'mysql';
    }

    public function pdo(): PDO
    {
        return $this->pdo;
    }

    public function driver(): string
    {
        return $this->driver;
    }
}
