<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use Skyboard\Application\Services\AccountService;
use Skyboard\Application\Services\EmailVerificationService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountController
{
    public function __construct(
        private readonly AccountService $account,
        private readonly EmailVerificationService $verification
    ) {
    }

    public function get(Request $request): Response
    {
        $user = $request->getAttribute('user');
        if (!$user) {
            return Response::error('UNAUTHORIZED', 'Authentification requise.', [], 401);
        }

        $payload = $this->account->getAccount((int) $user['id']);
        return Response::ok($payload);
    }

    // Removed: updateProfile/requestVerification/verify/redeemLicense migrated to /api/commands (Non-Board Bus)
}
