<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use Skyboard\Application\Services\LicenseService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class ActivationController
{
    public function __construct(private readonly LicenseService $licenses)
    {
    }

    public function consume(Request $request): Response
    {
        $token = (string) ($request->query['token'] ?? '');
        if ($token === '') {
            return Response::error('TOKEN_REQUIRED', 'Token requis.', [], 422);
        }

        $result = $this->licenses->consumeActivationToken($token);
        $status = $result['status'] ?? 'error';
        if ($status !== 'ok') {
            $raw = (string) ($result['message'] ?? 'ACTIVATION_FAILED');
            $code = strtoupper($raw);
            $message = match ($code) {
                'TOKEN_NOT_FOUND' => 'Lien invalide ou expiré.',
                'TOKEN_USED' => 'Ce lien a déjà été utilisé.',
                'TOKEN_EXPIRED' => 'Le lien d’activation a expiré.',
                'TOKEN_INVALID' => 'Lien d’activation invalide.',
                default => 'Activation de licence échouée.',
            };
            return Response::error($code, $message, [], 422);
        }
        return Response::ok(['role' => $result['role'] ?? 'standard']);
    }
}
