<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use Skyboard\Application\Services\ActivityReadService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class ActivityController
{
    public function __construct(private readonly ActivityReadService $activity)
    {
    }

    public function list(Request $request): Response
    {
        $user = $request->getAttribute('user');
        if (!$user) {
            return Response::error('UNAUTHORIZED', 'Authentification requise.', [], 401);
        }
        $since = isset($request->query['since']) ? (int) $request->query['since'] : null;
        $boardId = isset($request->query['board_id']) ? (int) $request->query['board_id'] : null;
        $limit = isset($request->query['limit']) ? (int) $request->query['limit'] : 50;

        $payload = $this->activity->listForUser((int) $user['id'], $since, $boardId, $limit);
        return Response::ok($payload);
    }
}

