<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers\Admin;

use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

trait AdminControllerTrait
{
    private function requireAdmin(Request $request): ?Response
    {
        $user = $request->getAttribute('user');
        if (!$user) {
            return Response::error('UNAUTHORIZED', 'Authentification requise.', [], 401);
        }
        $role = (string) ($user['role'] ?? 'standard');
        if (!in_array($role, ['admin', 'superadmin'], true)) {
            return Response::error('FORBIDDEN', 'Accès réservé aux administrateurs.', [], 403);
        }
        return null;
    }
}
