<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use InvalidArgumentException;
use Skyboard\Application\Services\BoardRulesService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Throwable;

final class BoardRulesController
{
    public function __construct(private readonly BoardRulesService $service)
    {
    }

    public function export(Request $request): Response
    {
        $user = $request->getAttribute('user');
        if (!$user) {
            return Response::error('UNAUTHORIZED', 'Authentification requise.', [], 401);
        }

        $boardId = (int) ($request->query['boardId'] ?? 0);
        if ($boardId <= 0) {
            return Response::error('INVALID_PAYLOAD', 'Données invalides.', [], 422);
        }

        try {
            $rules = $this->service->export($boardId, (int) $user['id']);
        } catch (InvalidArgumentException $e) {
            return Response::error('NOT_FOUND', $e->getMessage(), [], 404);
        }

        return Response::ok([
            'exportedAt' => gmdate('c'),
            'rules' => $rules,
        ]);
    }

    // Removed: import migrated to Non-Board Bus (BoardRules.Import)
}
